/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import net.adventurez.block.entity.DragonEggEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={DragonEggBlock.class})
public class DragonEggBlockMixin
implements EntityBlock {
    @Inject(method={"onUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onUseMixin(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> info) {
        if (ConfigInit.CONFIG.allow_other_dragon_hatching && player.m_21120_(hand).m_150930_(Items.f_42735_) && player.m_6844_(EquipmentSlot.HEAD).m_150930_(Items.f_42683_)) {
            if (!world.f_46443_) {
                player.m_21120_(hand).m_41774_(1);
                if (state.m_155947_()) {
                    ((DragonEggEntity)world.m_7702_(pos)).enableEggHatching();
                }
            } else {
                for (int i = 0; i < 20; ++i) {
                    world.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + world.f_46441_.m_188500_(), (double)pos.m_123342_() + world.f_46441_.m_188500_(), (double)pos.m_123343_() + world.f_46441_.m_188500_(), 0.0, 0.0, 0.0);
                }
            }
            info.setReturnValue((Object)InteractionResult.m_19078_((boolean)true));
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new DragonEggEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return DragonEggBlockMixin.checkType(type, BlockInit.DRAGON_EGG_ENTITY, world.f_46443_ ? DragonEggEntity::clientTick : DragonEggEntity::serverTick);
    }

    private static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> checkType(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

